/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.efmextra.skills.SAO;

import com.dfdyz.epicacg.registry.MySkillDataKeys;
import com.dfdyz.epicacg.registry.MySkills;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationProvider;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SAOBasicAtkPatch
extends BasicAttack {
    private static final UUID EVENT_UUID = UUID.fromString("f34b839d-ab91-ac46-b61d-1c681c904319");

    public SAOBasicAtkPatch(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!event.getAnimation().isBasicAttackAnimation()) {
                container.getDataManager().setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)0);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_5833_() && playerState.canBasicAttack();
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (!executer.getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (PlayerEvent)new BasicAttackEvent(executer))) {
            CapabilityItem cap = executer.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            StaticAnimation attackMotion = null;
            ServerPlayer player = (ServerPlayer)executer.getOriginal();
            SkillDataManager dataManager = executer.getSkill((SkillSlot)SkillSlots.BASIC_ATTACK).getDataManager();
            int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get());
            if (player.m_20159_()) {
                Entity entity = player.m_20202_();
                if (entity instanceof PlayerRideableJumping && ((PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                    attackMotion = ((AnimationProvider)cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size())).get();
                    ++comboCounter;
                }
            } else {
                List combo = cap.getAutoAttckMotion((PlayerPatch)executer);
                int comboSize = combo.size();
                boolean dashAttack = player.m_20142_();
                SkillContainer wp = executer.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                comboCounter = dashAttack ? (wp != null && wp.getSkill() == MySkills.SAO_SINGLESWORD_INTERNAL && ((Boolean)wp.getDataManager().getDataValue((SkillDataKey)MySkillDataKeys.DASH_LOCKED.get())).booleanValue() ? comboSize - 2 : comboSize - 3) : (comboCounter %= comboSize - 3);
                attackMotion = ((AnimationProvider)combo.get(comboCounter)).get();
                comboCounter = dashAttack ? 0 : comboCounter + 1;
            }
            dataManager.setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)comboCounter);
            if (attackMotion != null) {
                executer.playAnimationSynchronized(attackMotion, 0.0f);
            }
            executer.updateEntityState();
        }
    }

    public void updateContainer(SkillContainer container) {
        if (container.getExecuter().getTickSinceLastAction() > 50 && (Integer)container.getDataManager().getDataValue((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get()) > 0) {
            container.getDataManager().setData((SkillDataKey)MySkillDataKeys.BA_COMBO_COUNTER.get(), (Object)0);
        }
    }
}

